<?php
$logFile = 'logs.txt';

// Ensure the request is a POST request
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['deleteChunk'])) {
    // Read the contents of the log file
    $logs = file($logFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

    if ($logs === false) {
        die("Error: Could not read the log file.");
    }

    // Get the indices of the chunks to delete
    $chunksToDelete = isset($_POST['deleteChunk']) ? array_map('intval', $_POST['deleteChunk']) : [];

    // Define the number of lines per chunk
    $linesPerChunk = 12;

    // Rebuild the logs array excluding the selected chunks
    $newLogs = [];
    $chunkIndex = 0;

    foreach (array_chunk($logs, $linesPerChunk) as $index => $chunk) {
        if (!in_array($index, $chunksToDelete, true)) {
            $newLogs = array_merge($newLogs, $chunk);
        }
    }

    // Rewrite the log file with the remaining entries
    if (file_put_contents($logFile, implode(PHP_EOL, $newLogs) . PHP_EOL) === false) {
        echo "Error: Could not write to the log file.";
    } else {
        // Redirect to the display page
        header("Location: view_logs.php");
        exit();
    }
} else {
    echo "Invalid request.";
}
?>