<?php
$logFile = 'logs.txt';

// Read the contents of the log file
$logs = file($logFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

if ($logs === false) {
    die("Error: Could not read the log file.");
}

// Define the number of lines per chunk
$linesPerChunk = 12;
$totalLines = count($logs);
$chunks = array_chunk($logs, $linesPerChunk);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View and Manage Logs</title>
</head>
<body>
    <h2>Logs Management</h2>
    <form action="delete_logs_chunk.php" method="POST">
        <?php foreach ($chunks as $chunkIndex => $chunk): ?>
        <fieldset>
            <legend>Chunk <?php echo $chunkIndex + 1; ?></legend>
            <table>
                <thead>
                    <tr>
                        <th>Log Entry</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($chunk as $log): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($log, ENT_QUOTES, 'UTF-8'); ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <input type="hidden" name="chunkIndex[]" value="<?php echo $chunkIndex; ?>">
            <button type="submit" name="deleteChunk[]" value="<?php echo $chunkIndex; ?>">Delete This Chunk</button>
        </fieldset>
        <?php endforeach; ?>
    </form>
</body>
</html>